const mysql = require("mysql2");
const { DB_HOST, DB_USER, DB_PASSWORD,DB_NAME} = require("../config/index");

const pool = mysql.createPool({
  host: DB_HOST,
  user: DB_USER,
  password: DB_PASSWORD,
  database: DB_NAME,
});

// Wraps the pool.getConnection() function
function getConnection() {
  return new Promise((resolve, reject) => {
    pool.getConnection((err, connection) => {
      if (err) {
        reject(err);
        return;
      }

      resolve(connection);
    });
  });
}

// Performs a database query using a connection from the pool
// async function performQuery(sql, params) {
//   const connection = await getConnection();
//   console.log("connection: true ", connection);

//   try {
//     return new Promise((resolve, reject) => {
//       connection.query(sql, params, (error, results) => {
//         if (error) {
//           console.log(error);

//           reject(error);
//           return;
//         }
//         resolve(results);
//       });
//     });
//   } finally {
//     connection.release();
//   }
// }

async function performQuery(sql, params) {
  let connection;
  try {
    connection = await getConnection();
    // console.log("Connection acquired:", connection);

    return new Promise((resolve, reject) => {
      connection.query(sql, params, (error, results) => {
        if (error) {
          console.error("Query error:", error);
          reject(error);
        } else {
          resolve(results);
        }
      });
    });
  } catch (error) {
    console.error("Connection error:", error);
    throw error; // Re-throw the error after logging
  } finally {
    if (connection) {
      connection.release();
      console.log("Connection released");
    }
  }
}

module.exports = { pool, getConnection, performQuery };
