const multer = require("multer");
const path = require("path");

const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, "uploads/");
  },
  filename: (req, file, cb) => {
    console.log("FILE====>", file);

    cb(
      null,
      // file.filename + Date.now() + "_" + file.originalname);
      file.fieldname + "-" + Date.now() + path.extname(file.originalname)
    );
  },
});

const fileFilter = (req, file, cb)=> {
    if (
        file.mimetype === "image/jpeg" || 
        file.mimetype === "image/png"  ||
        file.mimetype === "image/jpg"
    ) {
      cb(null, true);
    } else {
      cb("please upload only image.", false);
    }
}

// const uploadImg = multer({ storage, fileFilter });
const uploadImg = multer({ storage:storage, fileFilter:fileFilter });

module.exports = uploadImg;
