const tables = require("../utils/tables")
const {performQuery} = require("../utils/db")
const {sendResponse, sendErrorResponse} = require("../utils")



//=====> Create Api for userpriority
module.exports.createUserPriority = async (req, res) => {
  try {
    // const {email, defectCategory_Id, activeStatus} = req.body
    // if (!email || !defectCategory_Id || !activeStatus) {
    const {email, defectCategory_Id} = req.body
    if (!email || !defectCategory_Id) {
      const error = new Error("Fields are required")
      console.error("Validation Error:", error.message)
      console.log('validation erorr error');

      
      return sendErrorResponse(res, error, "Fields are required")
    }

    const insertQuery = `INSERT INTO ${tables.tables.userPriority} SET?`
    const insertParams = {email, defectCategory_Id}


    console.log("Insert Parameters:", insertParams)

    const result = await performQuery(insertQuery, insertParams)
    return sendResponse(res, result, "user priority created successfully", 201)
  } catch (error) {
    console.error('Error:', error.message)
    console.log("Error in creating user priority")
    return sendErrorResponse(res, error, "Error while creating user priority")
  }
}

//===> Select API for all tables
module.exports.getuserPriorities = async (req, res) => {
  try {
    // const selectuserPriority = `SELECT * FROM ${tables.userPriority} order by id DESE`
    const selectuserPriority = `
    SELECT 
      u.id, u.email, u.defectCategory_Id, 
      (
        SELECT 
          c.category 
        FROM 
          ${tables.tables.defectCategory} As c 
        WHERE 
          c.id=u.defectcategory_Id
      ) As defectCategory 
    FROM 
      ${tables.tables.userPriority} AS u order by id DESC;`;
    const userPriorities = await performQuery(selectuserPriority)
    console.log("userPriorities====>", userPriorities);
    
    return sendResponse(res, userPriorities, "fetch user priorities successfully", 200)
  } catch (error) {
    console.error('Error:', error.message)
    console.log("Error in fetching user priority")
    return sendErrorResponse(res, error, "Error while fetching user priority")
  }
}


//======> Select API for Single
module.exports.getUserPriority = async (req, res) => {
  
   try {
    const { id } = req.params;
    if (!id) {
      const error = new Error("Id is required");
      console.error("Validation Error:", error.message)
      console.log('validation erorr error');
      return sendErrorResponse(res, error, "Id is required");
    }
    const selectuserPriority = `SELECT * FROM ${tables.tables.userPriority} WHERE id =${id}`
    //===> Perform DB Query
    const userPriority = await performQuery(selectuserPriority)
    return sendResponse(res, userPriority, "fetch user priority successfully", 200)
  }
  catch (error) {
    return sendErrorResponse(res, error, "Failed to fetch")
   }
}

//==========> Update API for user priority =================
module.exports.updateUserPriority = async (req, res) => {
  try {
    const { id, email, defectCategory_Id } = req.body;

    if ((!email, !defectCategory_Id)) {
      const error = new Error("Fields are required");
      return sendErrorResponse(res, error, "Fields are required");
    }

    // ===> for limited data
    const updateQuery = `UPDATE ${tables.tables.userPriority} SET email=?, defectCategory_Id=? WHERE id=?`;
    const updateParams = [email, defectCategory_Id, id];

    //==> perform the database query
    const result = await performQuery(updateQuery, updateParams);
    if (result) {
      return sendResponse(res, result, "part update successfully", 201);
    }
  } catch (error) {
    console.log("Error in updating data");
    return sendErrorResponse(res, error, "Error while updating priorities");
  }
};


// =======> Delete API for user priority <=================
module.exports.deleteUserPriority = async (req, res) => {
  try {

    // const { id } = req.params;
    //const { id } = req.body;
    
   const { id } = req.query;
   console.log(req.query, "this is request.body");

    if (!id) {
      const error = new Error("Id is required");
      return sendErrorResponse(res, error, "Id is required");
    }

    const deleteQuery = `DELETE FROM ${tables.tables.userPriority} WHERE id=?`;
    const deleteParams = [id];

    //==> perform the database query
    const result = await performQuery(deleteQuery, deleteParams);
    console.log(result, "this is result");
    if (result) {
    console.log("user priority deleted successfully");
      return sendResponse(res, result, "user priority deleted successfully");
    }
  } catch (error) {
    console.log("Error in deleting data");
    return sendErrorResponse(res, error, "Error while deleting user priority");
  }
};