// const tables = require("../utils/tables");

// const { performQuery } = require("../utils/db");
// const { sendResponse, sendErrorResponse } = require("../utils");
// const { sendMail } = require("../services/MAIL");
// const { handleSanitizeInputFields } = require("../utils/SanitizeInputFields");
// const path = require("path");
// const fs = require("fs");

// //======> Select All Defects <=====
// module.exports.getdefect = async (req, res) => {
//   try {
//     // const selectuserPriority = `SELECT * FROM ${tables.userPriority} order by id DESE`

//     const selectDefects = `SELECT
//     d.id ,
//     d.cil_Id,
//     c.taskName AS task,
//     l.line AS line,
//     e.equipment AS equipment,
//     e.equipmentOwnerId,
//     u4.name AS equipmentOwner,
//     dc.category AS defectCategory,
//     dp.part AS defectPart,
//     dt.type AS defectType,
//     d.imageFile,
//     d.details,
//     d.actions,
//     u3.name AS responsibleBy,
//     d.priority,
//     d.defectStatus,
//     d.isRepeated,
//     u1.name AS createdBY,
//     d.creationDate,
//     d.foundDate,
//     d.expectedSolvedDate,
//     d.SolvedDate,
//     d.finalImage,
//     u2.name AS solvedBy
//     FROM
//       oee2024_newDH.defects AS d
//     LEFT JOIN
//       oee2024_NewCIL.configCIL AS c ON c.id = d.cil_Id
//     LEFT JOIN
//       oee2024_new_active_directory.line AS l ON l.id = d.line_id
//     LEFT JOIN
//       oee2024_new_active_directory.equipment AS e ON e.id  = d.equip_Id
//     LEFT JOIN
//       oee2024_newDH.defectCategory AS dc ON dc.id = d.defectCategory_Id
//     LEFT JOIN
//       oee2024_newDH.defectPart AS dp ON dp.id = d.defectPart_Id
//     LEFT JOIN
//       oee2024_newDH.defectType AS dt ON dt.id = d.defectType_Id
//     LEFT JOIN
//       oee2024_new_active_directory.users AS u1 ON u1.id = d.createdById
//     LEFT JOIN
//       oee2024_new_active_directory.users AS u2 ON u2.id = d.SolvedById
//     LEFT JOIN
//       oee2024_new_active_directory.users AS u3 ON u3.id = d.responsibleById
//     LEFT JOIN
//       oee2024_new_active_directory.users AS u4 ON u4.id=e.equipmentOwnerId;`;

//     const defects = await performQuery(selectDefects);
//     return sendResponse(res, defects, "Fetch defects successfully", 200);
//   } catch (error) {
//     console.error("Error:", error.message);
//     console.log("Error in fetching defects");
//     return sendErrorResponse(res, error, "Error while fetching defects");
//   }
// };

// //======> Select API for Single defect <=====
// module.exports.getSingleDefect = async (req, res) => {
//   try {
//     // const { id } = req.query;
//     const { id } = req.params;
//     if (!id) {
//       const error = new Error("Id is required");
//       return sendErrorResponse(res, error, "Id is required");
//     }
//     const selectdefectQuery = `SELECT * FROM ${tables.defects} WHERE id=${id}`;
//     // Perform the database query
//     const configCIL = await performQuery(selectdefectQuery);
//     return sendResponse(res, configCIL, "Fetch defect data successfully", 200);
//   } catch (error) {
//     return sendErrorResponse(res, error, "Error while fetching defect");
//   }
// };

// //========> Create API for defect =================
// module.exports.createDefect = async (req, res) => {
//   try {
//     const {
//       cil_Id,
//       line_Id,
//       equip_Id,
//       defectCategory_Id,
//       defectPart_Id,
//       defectType_Id,
//       // imageFile,
//       details,
//       actions,
//       responsibleById,
//       // defectStatus,
//       isRepeated,
//       createdById,
//       // creationDate,
//       foundDate,
//       expectedSolvedDate,
//     } = req.body;

//     // ==============> get date and time ================
//     let today = new Date();
//     // Getting the date in ISO format (YYYY-MM-DD)
//     let date = today.toISOString().split("T")[0];

//     // Getting the time in ISO format (HH:MM:SS)
//     // let time = today.toISOString().split("T")[1].split(".")[0];

//     //====> getting the time in Pakistani format
//     let options = {
//       timeZone: "Asia/Karachi",
//       hour: "2-digit",
//       minute: "2-digit",
//       second: "2-digit",
//       hour12: false, // Use 24-hour format to avoid AM/PM
//     };
//     let pakistanTime = today.toLocaleTimeString("en-US", options);

//     // Replacing colons with hyphens in the time string and removing any spaces
//     let timeWithHyphens = pakistanTime.replace(/:/g, "-").replace(/\s/g, "");
//     console.log("timeWithHyphens=======>", timeWithHyphens);
//     // store date in creationDate var
//     let creationDate = date;

//     // ==============> image work start ================
//     let imageFileURL = "";
//     // Check if imageUpload file is present
//     if (req?.files?.imageFile) {
//       const imageFile = req.files.imageFile;
//       //=====> working for image name and image extension
//       let imageFilename = imageFile.name;
//       // let imageNameWithExe = imageFilename;
//       // let namepart = parts[0]
//       // let extension = parts[1]

//       // const imageUploadPath = `${__dirname}/uploads/${date}-${timeWithHyphens}-${imageFile.name}`;
//       // const imageUploadPath = `${__dirname}/uploads/${namepart}-${date}-${timeWithHyphens}.${extension}`;
//       const imageUploadPath = `${__dirname}/uploads/${date}-${timeWithHyphens}-${imageFilename}`;

//       // Use the mv() method to place the file somewhere on your server
//       imageFile.mv(imageUploadPath, function (err) {
//         if (err) {
//           console.log("Error while uploading file: ", err);
//           return res.status(500).send(err);
//         }
//       });
//       const hostUrl = "https://" + req.headers.host;
//       imageFileURL = `${hostUrl}/uploads/${date}-${timeWithHyphens}-${imageFilename}`;
//     } else {
//       imageFileURL = "N/A";
//     }
//     // ==============> image work end ================

//     // Validate the request body fields
//     if (
//       !line_Id ||
//       !equip_Id ||
//       !defectCategory_Id ||
//       !defectPart_Id ||
//       !defectType_Id ||
//       !details ||
//       !actions ||
//       !responsibleById ||
//       !isRepeated ||
//       !createdById ||
//       !foundDate ||
//       !expectedSolvedDate
//     ) {
//       const error = new Error("All fields are required");
//       return sendErrorResponse(res, error, "All fields are required");
//     }

//     // check special character to avoid them
//     const isDatailsDataSafe = handleSanitizeInputFields(details);
//     const isActionsDataSafe = handleSanitizeInputFields(actions);
//     if (!isDatailsDataSafe || !isActionsDataSafe) {
//       const error = new Error("This Characters is prohibited");
//       return sendErrorResponse(res, error, "This Characters is prohibited");
//     }

//     // check comming category exist in users priotity table
//     const selectPrioritytRecord = `SELECT * FROM  ${tables.userPriority} WHERE defectCategory_Id=${defectCategory_Id}`;
//     const priorityRecord = await performQuery(selectPrioritytRecord);
//     // if exsit then send 1 in priotity otherwise 0
//     let priority = priorityRecord.length > 0 ? 1 : 0;

//     const insertDefectQuery = `INSERT INTO ${tables.defects} (cil_Id, line_id, equip_Id, defectCategory_Id, defectPart_Id, defectType_Id, imageFile, details, actions, responsibleById, priority, isRepeated, createdById, creationDate, foundDate, expectedSolvedDate) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`;
//     const values = [
//       cil_Id,
//       line_Id,
//       equip_Id,
//       defectCategory_Id,
//       defectPart_Id,
//       defectType_Id,
//       imageFileURL,
//       details,
//       actions,
//       responsibleById,
//       priority,
//       // defectStatus,
//       isRepeated,
//       createdById,
//       // date,
//       creationDate,
//       foundDate,
//       expectedSolvedDate,
//     ];
//     // Perform the database query
//     const result = await performQuery(insertDefectQuery, values);
//     if (result) {
//       if (priorityRecord?.length > 0) {
//         const selectDefects = `SELECT
//         d.id ,
//         d.cil_Id,
//         c.taskName AS task,
//         l.line AS line,
//         e.equipment AS equipment,
//         e.equipmentOwnerId,
//         u4.name AS equipmentOwner,
//         dc.category AS defectCategory,
//         dp.part AS defectPart,
//         dt.type AS defectType,
//         d.imageFile,
//         d.details,
//         d.actions,
//         u3.name AS responsibleBy,
//         d.priority,
//         d.defectStatus,
//         d.isRepeated,
//         u1.name AS createdBY,
//         d.creationDate,
//         d.foundDate,
//         d.expectedSolvedDate,
//         d.SolvedDate,
//         u2.name AS solvedBy
//         FROM
//         oee2024_newDH.defects AS d 
//         LEFT JOIN
//         oee2024_NewCIL.configCIL AS c ON c.id = d.cil_Id
//         LEFT JOIN
//         oee2024_new_active_directory.line AS l ON l.id = d.line_id
//         LEFT JOIN
//         oee2024_new_active_directory.equipment AS e ON e.id  = d.equip_Id
//         LEFT JOIN
//         oee2024_newDH.defectCategory AS dc ON dc.id = d.defectCategory_Id
//         LEFT JOIN
//         oee2024_newDH.defectPart AS dp ON dp.id = d.defectPart_Id
//         LEFT JOIN
//         oee2024_newDH.defectType AS dt ON dt.id = d.defectType_Id
//         LEFT JOIN
//         oee2024_new_active_directory.users AS u1 ON u1.id = d.createdById
//         LEFT JOIN
//         oee2024_new_active_directory.users AS u2 ON u2.id = d.SolvedById
//         LEFT JOIN
//          oee2024_new_active_directory.users AS u3 ON u3.id = d.responsibleById
//         LEFT JOIN
//          oee2024_new_active_directory.users AS u4 ON u4.id=e.equipmentOwnerId
//         ORDER BY id DESC;`;

//         const allDefects = await performQuery(selectDefects);
//         // console.log("allDefects>>>",allDefects);
//         console.log("allDefects>>>", allDefects[0]);

//         await sendMail(priorityRecord, allDefects[0]);
//       }
//     }
//     return sendResponse(res, result, "defect created successfully", 201);
//   } catch (error) {
//     console.log("Error in creating defect", error.message);
//     console.error("Error in creating defect");
//     return sendErrorResponse(res, error, "Error while creating defect");
//   }
// };

// //====> Update API for update defect status =================
// // module.exports.updateDefectStatus = async (req, res) => {
// //   try {
// //     const { id, defectStatus, SolvedById } = req.body;

// //     let today = new Date(); // get current date and time
// //     const SolvedDate = today.toISOString().split("T")[0]; // store current date only

// //     // ===> check for empty fields
// //     if (!id || !defectStatus || !SolvedById) {
// //       const error = new Error("Fields are required");
// //       return sendErrorResponse(res, error, "Fields are required");
// //     }
// //     const updateQuery = `UPDATE ${tables.defects} SET defectStatus=?, SolvedById=?, SolvedDate=? WHERE id=?`;
// //     const updateParams = [defectStatus, SolvedById, SolvedDate, id];

// //     //==> perform the database query
// //     const result = await performQuery(updateQuery, updateParams);
// //     if (result) {
// //       return sendResponse(res, result, "Defct status update successfully", 201);
// //     }
// //   } catch (error) {
// //     console.log("Error in updating data");
// //     return sendErrorResponse(res, error, "Error while updating defect status");
// //   }
// // };


// // module.exports.updateDefectStatus = async (req, res) => {
// //   try {
// //     const { id, defectStatus, SolvedById } = req.body;
// //     let finalImage = req.files ? req.files.filename : null; 
// //     // let finalImage = req.file ? req.file.filename : null; 
// //     console.log("finalImage=>", finalImage);
// //     // if (req.file) {
// //     //   const imagePath = path.join(__dirname, "..", "uploads", req.file.filename);
// //     //   fs.unlinkSync(imagePath); // Delete the old image file
// //     // }

// //     let today = new Date(); 
// //     const SolvedDate = today.toISOString().split("T")[0]; // Store only the date

// //     // ===> Check for required fields
// //     if (!id || !defectStatus || !SolvedById) {
// //       const error = new Error("Fields are required");
// //       return sendErrorResponse(res, error, "Fields are required");
// //     }

// //     // ===> Update Query (Adding finalImage conditionally)
// //     const updateQuery = `UPDATE ${tables.defects} 
// //                          SET defectStatus=?, SolvedById=?, SolvedDate=?, finalImage=? 
// //                          WHERE id=?`;
// //     const updateParams = [defectStatus, SolvedById, SolvedDate, finalImage, id];
// //     console.log("updateParams=>", updateParams);

// //     //==> Perform the database query
// //     const result = await performQuery(updateQuery, updateParams);
// //     if (result) {
// //       return sendResponse(res, result, "Defect status updated successfully", 201);
// //     }
// //   } catch (error) {
// //     console.log("Error in updating data", error.message);
// //     return sendErrorResponse(res, error, "Error while updating defect status");
// //   }
// // };

// module.exports.updateDefectStatus = async (req, res) => {
//   try {
//     const { id, defectStatus, SolvedById } = req.body;

//     // ===> Get current date
//     let today = new Date();
//     let SolvedDate = today.toISOString().split("T")[0]; // YYYY-MM-DD format

//     // ===> Pakistani Time Format
//     let options = {
//       timeZone: "Asia/Karachi",
//       hour: "2-digit",
//       minute: "2-digit",
//       second: "2-digit",
//       hour12: false,
//     };
//     let pakistanTime = today.toLocaleTimeString("en-US", options);
//     let timeWithHyphens = pakistanTime.replace(/:/g, "-").replace(/\s/g, "");

//     // ===> Validate required fields
//     if (!id || !defectStatus || !SolvedById) {
//       const error = new Error("Fields are required");
//       return sendErrorResponse(res, error, "Fields are required");
//     }

//     // ===> Image Upload Handling
//     let finalImageURL = "";
//     if (req?.files?.finalImage) {
//       const imageFile = req.files.finalImage;
//       let imageFilename = `${SolvedDate}-${timeWithHyphens}-${imageFile.name}`;
//       const imageUploadPath = path.join(__dirname, "uploads", imageFilename);

//       //==> Save image
//       imageFile.mv(imageUploadPath, (err) => {
//         if (err) {
//           console.log("Error while uploading file: ", err);
//           return res.status(500).send(err);
//         }
//       });

//       //==> Generate Image URL
//       const hostUrl = "https://" + req.headers.host;
//       finalImageURL = `${hostUrl}/uploads/${imageFilename}`;
//     } else {
//       finalImageURL = "N/A";
//     }

//     const updateQuery = `UPDATE ${tables.defects} 
//                          SET defectStatus=?, SolvedById=?, SolvedDate=?, finalImage=? 
//                          WHERE id=?`;
//     const updateParams = [defectStatus, SolvedById, SolvedDate, finalImageURL, id];

//     const result = await performQuery(updateQuery, updateParams);
//     if (result) {
//       return sendResponse(res, result, "Defect status updated successfully", 201);
//     }
//   } catch (error) {
//     console.log("Error in updating data", error.message);
//     return sendErrorResponse(res, error.message, "Error while updating defect status");
//   }
// };

// Upgraded Api 

const tables = require("../utils/tables");
const { performQuery } = require("../utils/db");
const { sendResponse, sendErrorResponse } = require("../utils");
const { sendMail } = require("../services/MAIL");
const { handleSanitizeInputFields } = require("../utils/SanitizeInputFields");
const path = require("path");
const fs = require("fs");


//========> Create API for defect =================
module.exports.createDefect = async (req, res) => {
  try {
    const {
      cil_Id,
      line_Id,
      equip_Id,
      defectCategory_Id,
      defectPart_Id,
      defectType_Id,
      // imageFile,
      details,
      actions,
      responsibleById,
      // defectStatus,
      isRepeated,
      createdById,
      // creationDate,
      foundDate,
      expectedSolvedDate,
    } = req.body;

    // ==============> get date and time ================
    let today = new Date();
    // Getting the date in ISO format (YYYY-MM-DD)
    let date = today.toISOString().split("T")[0];

    // Getting the time in ISO format (HH:MM:SS)
    // let time = today.toISOString().split("T")[1].split(".")[0];

    //====> getting the time in Pakistani format
    let options = {
      timeZone: "Asia/Karachi",
      hour: "2-digit",
      minute: "2-digit",
      second: "2-digit",
      hour12: false, // Use 24-hour format to avoid AM/PM
    };
    let pakistanTime = today.toLocaleTimeString("en-US", options);

    // Replacing colons with hyphens in the time string and removing any spaces
    let timeWithHyphens = pakistanTime.replace(/:/g, "-").replace(/\s/g, "");
    console.log("timeWithHyphens=======>", timeWithHyphens);
    // store date in creationDate var
    let creationDate = date;

    // ==============> image work start ================
    let imageFileURL = "";
    // Check if imageUpload file is present
    if (req?.files?.imageFile) {
      const imageFile = req.files.imageFile;
      //=====> working for image name and image extension
      let imageFilename = imageFile.name;
      // let imageNameWithExe = imageFilename;
      // let namepart = parts[0]
      // let extension = parts[1]

      // const imageUploadPath = `${__dirname}/uploads/${date}-${timeWithHyphens}-${imageFile.name}`;
      // const imageUploadPath = `${__dirname}/uploads/${namepart}-${date}-${timeWithHyphens}.${extension}`;
      const imageUploadPath = `${__dirname}/uploads/${date}-${timeWithHyphens}-${imageFilename}`;

      // Use the mv() method to place the file somewhere on your server
      imageFile.mv(imageUploadPath, function (err) {
        if (err) {
          console.log("Error while uploading file: ", err);
          return res.status(500).send(err);
        }
      });
      const hostUrl = "https://" + req.headers.host;
      imageFileURL = `${hostUrl}/uploads/${date}-${timeWithHyphens}-${imageFilename}`;
    } else {
      imageFileURL = "N/A";
    }
    // ==============> image work end ================

    // Validate the request body fields
    if (
      !line_Id ||
      !equip_Id ||
      !defectCategory_Id ||
      !defectPart_Id ||
      !defectType_Id ||
      !details ||
      !actions ||
      !responsibleById ||
      !isRepeated ||
      !createdById ||
      !foundDate ||
      !expectedSolvedDate
    ) {
      const error = new Error("All fields are required");
      return sendErrorResponse(res, error, "All fields are required");
    }

    // check special character to avoid them
    const isDatailsDataSafe = handleSanitizeInputFields(details);
    const isActionsDataSafe = handleSanitizeInputFields(actions);
    if (!isDatailsDataSafe || !isActionsDataSafe) {
      const error = new Error("This Characters is prohibited");
      return sendErrorResponse(res, error, "This Characters is prohibited");
    }

    // check comming category exist in users priotity table
    const selectPrioritytRecord = `SELECT * FROM  ${tables.tables.userPriority} WHERE defectCategory_Id=${defectCategory_Id}`;
    const priorityRecord = await performQuery(selectPrioritytRecord);
    // if exsit then send 1 in priotity otherwise 0
    let priority = priorityRecord.length > 0 ? 1 : 0;

    const insertDefectQuery = `INSERT INTO ${tables.tables.defects} (cil_Id, line_id, equip_Id, defectCategory_Id, defectPart_Id, defectType_Id, imageFile, details, actions, responsibleById, priority, isRepeated, createdById, creationDate, foundDate, expectedSolvedDate) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`;
    const values = [
      cil_Id,
      line_Id,
      equip_Id,
      defectCategory_Id,
      defectPart_Id,
      defectType_Id,
      imageFileURL,
      details,
      actions,
      responsibleById,
      priority,
      // defectStatus,
      isRepeated,
      createdById,
      // date,
      creationDate,
      foundDate,
      expectedSolvedDate,
    ];
    // Perform the database query
    const result = await performQuery(insertDefectQuery, values);
    if (result) {
      if (priorityRecord?.length > 0) {
        const selectDefects = `SELECT
        d.id ,
        d.cil_Id,
        // c.taskName AS task,
        l.line AS line,
        e.equipment AS equipment,
        e.equipmentOwnerId,
        u4.name AS equipmentOwner,
        dc.category AS defectCategory,
        dp.part AS defectPart,
        dt.type AS defectType,
        d.imageFile,
        d.details,
        d.actions,
        u3.name AS responsibleBy,
        d.priority,
        d.defectStatus,
        d.isRepeated,
        u1.name AS createdBY,
        d.creationDate,
        d.foundDate,
        d.expectedSolvedDate,
        d.SolvedDate,
        u2.name AS solvedBy
        FROM
        ${tables.tables.defects} AS d 
        LEFT JOIN
        oee2024_NewCIL.configCIL AS c ON c.id = d.cil_Id
        LEFT JOIN
        ${tables.tables.line} AS l ON l.id = d.line_id
        LEFT JOIN
        ${tables.tables.equipment} AS e ON e.id  = d.equip_Id
        LEFT JOIN
        ${tables.tables.defectCategory} AS dc ON dc.id = d.defectCategory_Id
        LEFT JOIN
        ${tables.tables.defectPart} AS dp ON dp.id = d.defectPart_Id
        LEFT JOIN
        ${tables.tables.defectType} AS dt ON dt.id = d.defectType_Id
        LEFT JOIN
        ${tables.tables.users} AS u1 ON u1.id = d.createdById
        LEFT JOIN
        ${tables.tables.users} AS u2 ON u2.id = d.SolvedById
        LEFT JOIN
         ${tables.tables.users} AS u3 ON u3.id = d.responsibleById
        LEFT JOIN
         ${tables.tables.users} AS u4 ON u4.id=e.equipmentOwnerId
        ORDER BY id DESC;`;

        const allDefects = await performQuery(selectDefects);
        // console.log("allDefects>>>",allDefects);
        console.log("allDefects>>>", allDefects[0]);

        await sendMail(priorityRecord, allDefects[0]);
      }
    }
    return sendResponse(res, result, "defect created successfully", 201);
  } catch (error) {
    console.log("Error in creating defect", error.message);
    console.error("Error in creating defect");
    return sendErrorResponse(res, error, "Error while creating defect");
  }
};


//======> Select All Defects <=====
module.exports.getDefect = async (req, res) => {
  try {
    // const selectuserPriority = `SELECT * FROM ${tables.userPriority} order by id DESE`

    // LEFT JOIN
    // oee2024_NewCIL.configCIL AS c ON c.id = d.cil_Id
    // c.taskName AS task 
    const selectDefects = `SELECT
    d.id ,
    d.cil_Id,
    c.taskName AS task,
    l.line AS line,
    e.equipment AS equipment,
    e.equipmentOwnerId,
    u4.name AS equipmentOwner,
    dc.category AS defectCategory,
    dp.part AS defectPart,
    dt.type AS defectType,
    d.imageFile,
    d.details,
    d.actions,
    u3.name AS responsibleBy,
    d.priority,
    d.defectStatus,
    d.isRepeated,
    u1.name AS createdBY,
    d.creationDate,
    d.foundDate,
    d.expectedSolvedDate,
    d.SolvedDate,
    d.finalImage,
    u2.name AS solvedBy
    FROM
      ${tables.tables.defects} AS d
    LEFT JOIN
      ${tables.tables.configCIL} AS c ON c.id = d.cil_Id
    LEFT JOIN
      ${tables.tables.lineFromAD} AS l ON l.id = d.line_id
    LEFT JOIN
      ${tables.tables.equipmentFromAD} AS e ON e.id  = d.equip_Id
    LEFT JOIN
      ${tables.tables.defectCategory} AS dc ON dc.id = d.defectCategory_Id
    LEFT JOIN
      ${tables.tables.defectPart} AS dp ON dp.id = d.defectPart_Id
    LEFT JOIN
      ${tables.tables.defectType} AS dt ON dt.id = d.defectType_Id
    LEFT JOIN
      ${tables.tables.usersFromAD} AS u1 ON u1.id = d.createdById
    LEFT JOIN
      ${tables.tables.usersFromAD} AS u2 ON u2.id = d.SolvedById
    LEFT JOIN
      ${tables.tables.usersFromAD} AS u3 ON u3.id = d.responsibleById
    LEFT JOIN
      ${tables.tables.usersFromAD} AS u4 ON u4.id=e.equipmentOwnerId;`;

    const defects = await performQuery(selectDefects);
    return sendResponse(res, defects, "Fetch defects successfully", 200);
  } catch (error) {
    console.error("Error:", error.message);
    console.log("Error in fetching defects");
    return sendErrorResponse(res, error, "Error while fetching defects");
  }
};

//======> Select API for Single defect <=====
module.exports.getSingleDefect = async (req, res) => {
  try {
    // const { id } = req.query;
    const { id } = req.params;
    if (!id) {
      const error = new Error("Id is required");
      return sendErrorResponse(res, error, "Id is required");
    }
    const selectdefectQuery = `SELECT * FROM ${tables.tables.defects} WHERE id=${id}`;
    // Perform the database query
    const configCIL = await performQuery(selectdefectQuery);
    return sendResponse(res, configCIL, "Fetch defect data successfully", 200);
  } catch (error) {
    return sendErrorResponse(res, error, "Error while fetching defect");
  }
};

module.exports.updateDefectStatus = async (req, res) => {
  try {
    const { id, defectStatus, SolvedById } = req.body;

    // ===> Get current date
    let today = new Date();
    let SolvedDate = today.toISOString().split("T")[0]; // YYYY-MM-DD format

    // ===> Pakistani Time Format
    let options = {
      timeZone: "Asia/Karachi",
      hour: "2-digit",
      minute: "2-digit",
      second: "2-digit",
      hour12: false,
    };
    let pakistanTime = today.toLocaleTimeString("en-US", options);
    let timeWithHyphens = pakistanTime.replace(/:/g, "-").replace(/\s/g, "");

    // ===> Validate required fields
    if (!id || !defectStatus || !SolvedById) {
      const error = new Error("Fields are required");
      return sendErrorResponse(res, error, "Fields are required");
    }

    // ===> Image Upload Handling
    let finalImageURL = "";
    if (req?.files?.finalImage) {
      const imageFile = req.files.finalImage;
      let imageFilename = `${SolvedDate}-${timeWithHyphens}-${imageFile.name}`;
      const imageUploadPath = path.join(__dirname, "uploads", imageFilename);

      //==> Save image
      imageFile.mv(imageUploadPath, (err) => {
        if (err) {
          console.log("Error while uploading file: ", err);
          return res.status(500).send(err);
        }
      });

      //==> Generate Image URL
      const hostUrl = "https://" + req.headers.host;
      finalImageURL = `${hostUrl}/uploads/${imageFilename}`;
    } else {
      finalImageURL = "N/A";
    }

    const updateQuery = `UPDATE ${tables.tables.defects} 
                         SET defectStatus=?, SolvedById=?, SolvedDate=?, finalImage=? 
                         WHERE id=?`;
    const updateParams = [
      defectStatus,
      SolvedById,
      SolvedDate,
      finalImageURL,
      id,
    ];

    const result = await performQuery(updateQuery, updateParams);
    if (result) {
      return sendResponse(
        res,
        result,
        "Defect status updated successfully",
        201,
      );
    }
  } catch (error) {
    console.log("Error in updating data", error.message);
    return sendErrorResponse(
      res,
      error.message,
      "Error while updating defect status",
    );
  }
};

//====> Update API for update defect status =================
// module.exports.updateDefectStatus = async (req, res) => {
//   try {
//     const { id, defectStatus, SolvedById } = req.body;

//     let today = new Date(); // get current date and time
//     const SolvedDate = today.toISOString().split("T")[0]; // store current date only

//     // ===> check for empty fields
//     if (!id || !defectStatus || !SolvedById) {
//       const error = new Error("Fields are required");
//       return sendErrorResponse(res, error, "Fields are required");
//     }
//     const updateQuery = `UPDATE ${tables.defects} SET defectStatus=?, SolvedById=?, SolvedDate=? WHERE id=?`;
//     const updateParams = [defectStatus, SolvedById, SolvedDate, id];

//     //==> perform the database query
//     const result = await performQuery(updateQuery, updateParams);
//     if (result) {
//       return sendResponse(res, result, "Defct status update successfully", 201);
//     }
//   } catch (error) {
//     console.log("Error in updating data");
//     return sendErrorResponse(res, error, "Error while updating defect status");
//   }
// };

// module.exports.updateDefectStatus = async (req, res) => {
//   try {
//     const { id, defectStatus, SolvedById } = req.body;
//     let finalImage = req.files ? req.files.filename : null;
//     // let finalImage = req.file ? req.file.filename : null;
//     console.log("finalImage=>", finalImage);
//     // if (req.file) {
//     //   const imagePath = path.join(__dirname, "..", "uploads", req.file.filename);
//     //   fs.unlinkSync(imagePath); // Delete the old image file
//     // }

//     let today = new Date();
//     const SolvedDate = today.toISOString().split("T")[0]; // Store only the date

//     // ===> Check for required fields
//     if (!id || !defectStatus || !SolvedById) {
//       const error = new Error("Fields are required");
//       return sendErrorResponse(res, error, "Fields are required");
//     }

//     // ===> Update Query (Adding finalImage conditionally)
//     const updateQuery = `UPDATE ${tables.defects}
//                          SET defectStatus=?, SolvedById=?, SolvedDate=?, finalImage=?
//                          WHERE id=?`;
//     const updateParams = [defectStatus, SolvedById, SolvedDate, finalImage, id];
//     console.log("updateParams=>", updateParams);

//     //==> Perform the database query
//     const result = await performQuery(updateQuery, updateParams);
//     if (result) {
//       return sendResponse(res, result, "Defect status updated successfully", 201);
//     }
//   } catch (error) {
//     console.log("Error in updating data", error.message);
//     return sendErrorResponse(res, error, "Error while updating defect status");
//   }
// };

