const express = require("express");
const mysql = require("mysql2");
const cors = require("cors");
const morgan = require("morgan");
const fileUpload = require("express-fileupload");
const helmet = require("helmet");
const http = require("http");
const path = require("path");
const api = require("./routes/router");
// const api = express.Router();
const { nextTick } = require("process");
const { sendResponse, sendErrorResponse } = require("./utils");
const { performQuery } = require("./utils/db");
const tables = require("./utils/tables");
const multer = require("multer");

const app = express();
app.use(cors("*"));
app.use(morgan("dev"));
app.use(express.urlencoded({ extended: false }));
app.use(express.json({ extended: false }));
app.use(express.json());
app.use(express.static("public"));
app.use(fileUpload({ safeFileNames: true, preserveExtension: true }));

// ===> for images
// Server files from the "uploads" directory
app.use("/uploads", express.static(path.join(__dirname, "controllers/uploads")));

// ===> for API's
app.use(
  "/api",
  (req, res, next) => {
    next();
  },
  api
);
app.use(
  "/",
  express.static(path.resolve(path.join(__dirname, "./client/dist")))
);

app.use(
  "*",
  express.static(path.resolve(path.join(__dirname, "./client/dist")))
);
const PORT = process.env.PORT || 5000;
app.listen(PORT, () => {
  console.log(`Server is running on: http://localhost:${PORT}`);
});

// const express = require("express");
// const mysql = require("mysql2");
// const cors = require("cors");
// const morgan = require("morgan");
// const fileUpload = require("express-fileupload");
// const helmet = require("helmet");
// const path = require("path");
// const api = require("./routes/router");
// // const multer = require("multer");

// const app = express();

// app.use(cors());
// app.use(morgan("dev"));
// app.use(express.urlencoded({ extended: false }));
// app.use(express.json());
// app.use(express.static("public"));
// app.use(fileUpload({ safeFileNames: true, preserveExtension: true }));

// // Uncomment and customize Helmet to avoid 'blocked:csp' issues
// // app.use(helmet({ contentSecurityPolicy: false }));

// // API Routes
// app.use("/api", api);

// // Static Files
// app.use(express.static(path.resolve(path.join(__dirname, "./client/dist"))));
// app.use("/uploads", express.static("uploads"));

// // Fallback for SPA
// app.use("*", express.static(path.resolve(path.join(__dirname, "./client/dist"))));

// // Error Handling Middleware (Optional)
// app.use((err, req, res, next) => {
//   console.error(err.stack);
//   res.status(500).send("Something went wrong!");
// });

// const PORT = process.env.PORT || 5000;
// app.listen(PORT, () => {
//   console.log(`Server is running on: http://localhost:${PORT}`);
// });